# norootforbuild

Name:         audio
BuildRequires: kernel-source kernel-syms
License:      GPL
Group:        System/Kernel
Summary:      Audio Kernel Module Package
Version:      1.1
Release:      0
Source0:      %name-%version.tar.gz
Patch0:       audio.patch
BuildRoot:    %{_tmppath}/%{name}-%{version}-build

%suse_kernel_module_package 

%description
This is Audio Kernel Module Package for SB600/SB700/SB800.

%package KMP
Summary: Audio Kernel Module
Group: System/Kernel

%description KMP
This is one of the sub-packages for a specific kernel. All the
sub-packages will share the same summary, group, and description.

%prep
%setup
%patch -p1
set -- *
mkdir source
mv "$@" source/
mkdir obj

%build
export EXTRA_CFLAGS='-DVERSION=\"%version\"'
for flavor in %flavors_to_build; do
    rm -rf obj/$flavor
    cp -r source obj/$flavor
    make -C /usr/src/linux-obj/%_target_cpu/$flavor modules \
	M=$PWD/obj/$flavor/sound/pci/hda
    make -C /usr/src/linux-obj/%_target_cpu/$flavor modules \
	M=$PWD/obj/$flavor/sound/usb
done

%install
export INSTALL_MOD_PATH=$RPM_BUILD_ROOT
export INSTALL_MOD_DIR=updates
for flavor in %flavors_to_build; do
    make -C /usr/src/linux-obj/%_target_cpu/$flavor modules_install \
	 M=$PWD/obj/$flavor/sound/pci/hda
    make -C /usr/src/linux-obj/%_target_cpu/$flavor modules_install \
	 M=$PWD/obj/$flavor/sound/usb
done

%changelog
* Fri Oct 24 2008 - Andiry Xu <Andiry.xu@amd.com>
- Initial package.
