# norootforbuild

Name:         ehci
BuildRequires: kernel-source kernel-syms
License:      GPL
Group:        System/Kernel
Summary:      EHCI Kernel Module Package
Version:      1.1
Release:      0
Source0:      %name-%version.tar.gz
Patch0:       SBX00_EHCI_fix_SLED10SP1.patch
BuildRoot:    %{_tmppath}/%{name}-%{version}-build

%suse_kernel_module_package kdump um debug

%description
This is EHCI Kernel Module Package. Quirk for SB600/SB700/SB800.

%package KMP
Summary: EHCI Kernel Module
Group: System/Kernel

%description KMP
This is one of the sub-packages for a specific kernel. All the
sub-packages will share the same summary, group, and description.

%prep
%setup
%patch -p1
set -- *
mkdir source
mv "$@" source/
mkdir obj

%build
export EXTRA_CFLAGS='-DVERSION=\"%version\"'
for flavor in %flavors_to_build; do
    rm -rf obj/$flavor
    cp -r source obj/$flavor
    make -C /usr/src/linux-obj/%_target_cpu/$flavor modules \
	M=$PWD/obj/$flavor/drivers/usb/host
done

%install
export INSTALL_MOD_PATH=$RPM_BUILD_ROOT
export INSTALL_MOD_DIR=updates
for flavor in %flavors_to_build; do
    make -C /usr/src/linux-obj/%_target_cpu/$flavor modules_install \
	 M=$PWD/obj/$flavor/drivers/usb/host
done

%changelog
* Mon May 19 2008 - henry.su@amd.com
- Build more kernel packages.
