#!/bin/bash

#Support SUSE Linux Enterprise server.
tmp=`grep "SUSE Linux Enterprise Server" /etc/issue`
if [ -z "$tmp" ]; then
        echo "This package is for Novell SLES OSes only."
        exit 1
fi

#Check the kernel version, should care about subversion?
tmp=`uname -r|grep "2.6.16"`
if [ -z "$tmp" ]; then
        echo "The kernel version `uname -r` is not supported."
        exit 1
fi

#Check whether XEN kernel has been installed.
xen=`ls /lib/modules | grep xen`
if [ -z "$xen" ]; then
        echo "No xen kernel found, this package is for xen kernel"
        exit 1
fi

#Check the machine:i386/x86_64, default/smp/bigsmp/xenpae
arch=`uname -a |grep i386`
xenpae=`ls /lib/modules | grep xenpae`

echo "Installing AHCI driver for xen kernel ..."
if [ -n "$arch" ]; then 
        if [ $xenpae=$xen ]; then
                rpm -ivh ../package/ahci/i586/ahci-kmp-xenpae-2.0_*.i586.rpm
        elif [ -n "$xenpae" ]; then
                rpm -ivh ../package/ahci/i586/ahci-kmp-xen-2.0_*.i586.rpm
                rpm -ivh ../package/ahci/i586/ahci-kmp-xenpae-2.0_*.i586.rpm
        else
                rpm -ivh ../package/ahci/i586/ahci-kmp-xen-2.0_*.i586.rpm
        fi
else
        rpm -ivh ../package/ahci/x86_64/ahci-kmp-xen-2.0_*.x86_64.rpm
fi

if [ "$?" -ne 0 ]; then
    echo "Upgrade AHCI driver for XEN kenel Failed! If you want to uninstall this rpm, please use command: 'rpm -e ahci-kmp-xen' or 'rpm -e ahci-kmp-xenpae'"
    exit 1
fi

echo "Upgrade AHCI driver for XEN kernel successfully! Please reboot the system"
