#!/bin/bash

#Support all SUSE Linux Enterprise, include desktop and server.
tmp=`grep "SUSE Linux Enterprise*" /etc/issue`
if [ -z "$tmp" ]; then
	echo "This package is for Novell SLED/SLES OSes only."
	exit 1
fi

#Check the kernel version, should care about subversion?
tmp=`uname -r|grep "2.6.16"`
if [ -z "$tmp" ]; then
	echo "The kernel version `uname -r` is not supported."
	exit 1
fi

#Check the machine:i386/x86_64, default/smp/bigsmp/xenpae
arch=`uname -a |grep i386`
tmp=`uname -r`
subarch=${tmp##*-}

echo "Installing USB EHCI driver for  `uname -r` kernel ..."
if [ -n "$arch" ]; then 
	rpm -ivh ../package/ehci/i586/ehci-kmp-${subarch}-1.1_*.i586.rpm
else
	rpm -ivh ../package/ehci/x86_64/ehci-kmp-${subarch}-1.1*.x86_64.rpm
fi

if [ "$?" -ne 0 ]; then
    echo "Upgrade USB EHCI driver Failed! The kernel verion maybe wrong."
    exit 1
fi

echo "Upgrade USB EHCI driver successfully! Please reboot the system."

