# norootforbuild

Name:         ahci
BuildRequires: kernel-source kernel-syms
License:      GPL
Group:        System/Kernel
Summary:      AHCI Kernel Module Package
Version:      2.0
Release:      0
Source0:      %name-%version.tar.gz
Patch0:       ahci_sb700_sles10sp1.patch
BuildRoot:    %{_tmppath}/%{name}-%{version}-build

%suse_kernel_module_package kdump um debug

%description
This is AHCI Kernel Module Package for SB600/SB700/SB800.

%package KMP
Summary: AHCI Kernel Module
Group: System/Kernel

%description KMP
This is one of the sub-packages for a specific kernel. All the
sub-packages will share the same summary, group, and description.

%prep
%setup
%patch -p1
set -- *
mkdir source
mv "$@" source/
mkdir obj

%build
export EXTRA_CFLAGS='-DVERSION=\"%version\"'
for flavor in %flavors_to_build; do
    rm -rf obj/$flavor
    cp -r source obj/$flavor
    make -C /usr/src/linux-obj/%_target_cpu/$flavor modules \
	M=$PWD/obj/$flavor/drivers/ata
done

%install
export INSTALL_MOD_PATH=$RPM_BUILD_ROOT
export INSTALL_MOD_DIR=updates
for flavor in %flavors_to_build; do
    make -C /usr/src/linux-obj/%_target_cpu/$flavor modules_install \
	 M=$PWD/obj/$flavor/drivers/ata
done

%changelog
* Fri Feb 20 2009 - harry.zhang@amd.com
- Build more kernel packages.
